<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$cls = '';

extract( shortcode_atts( array(
    'auto_scroll' => 'false',
    'loop' => 'false',
    'gap' => '30',
    'show_bullets' => '',
    'bullet_color' => '',
    'show_arrows' => '',
    'arrow_color' => '',
    'arrow_position' => 'center',
    'arrow_between' => '50',
    'bullet_between' => '50',
    'arrow_offset' => 'center',
    'arrow_offset_v' => '0',
    'arrow_offset_s' => '50',
    'column'        => '3c',
    'column2'       => '2c',
    'column3'       => '1c'
), $atts ) );

if ( $show_arrows ) {
    $cls .= ' has-arrows' .' arrow-'. $arrow_color;

    if ( $arrow_position == 'center' ) {
        $cls .= ' arrow-'. $arrow_position .' offset'. $arrow_offset .' offset-v'. $arrow_offset_v;
    } else {
        $cls .= ' arrow-'. $arrow_position .' arrow'. $arrow_offset_s;
    }
}

if ( $show_bullets )
    $cls .= ' has-bullets bullet-'. $bullet_color .' bullet'. $bullet_between; 

wp_enqueue_script( 'edukul-owlcarousel' );
printf(
    '<div class="edukul-carousel-box %8$s" data-auto="%5$s" data-loop="%6$s" data-gap="%7$s" data-column="%2$s" data-column2="%3$s" data-column3="%4$s">
        <div class="owl-carousel owl-theme">%1$s</div>
	</div>',
	do_shortcode( $content ),
    intval( $column ),
    intval( $column2 ),
    intval( $column3 ),
    $auto_scroll,
    $loop,
    intval( $gap ),
    $cls
);