<?php
if ( ! defined('ABSPATH') ) {
	die('Please do not load this file directly!');
}

add_action('init', 'register_partner_post_type');
/**
  * Register partner post type
*/
function register_partner_post_type() {
    $partner_slug = 'partner';

    $labels = array(
        'name'               => esc_html__( 'Partners', 'edukul' ),
        'singular_name'      => esc_html__( 'Partner Item', 'edukul' ),
        'add_new'            => esc_html__( 'Add New', 'edukul' ),
        'add_new_item'       => esc_html__( 'Add New Item', 'edukul' ),
        'new_item'           => esc_html__( 'New Item', 'edukul' ),
        'edit_item'          => esc_html__( 'Edit Item', 'edukul' ),
        'view_item'          => esc_html__( 'View Item', 'edukul' ),
        'all_items'          => esc_html__( 'All Items', 'edukul' ),
        'search_items'       => esc_html__( 'Search Items', 'edukul' ),
        'parent_item_colon'  => esc_html__( 'Parent Items:', 'edukul' ),
        'not_found'          => esc_html__( 'No items found.', 'edukul' ),
        'not_found_in_trash' => esc_html__( 'No items found in Trash.', 'edukul' )
    );

    $args = array(
        'labels'        => $labels,
        'rewrite'       => array( 'slug' => $partner_slug ),
        'supports'      => array( 'title', 'thumbnail' ),
        'public'        => true
    );

    register_post_type( 'partner', $args );
}

add_filter( 'post_updated_messages', 'partner_updated_messages' );
/**
  * Partner update messages.
*/
function partner_updated_messages( $messages ) {
    $post             = get_post();
    $post_type        = get_post_type( $post );
    $post_type_object = get_post_type_object( $post_type );

    $messages['partner'] = array(
        0  => '', // Unused. Messages start at index 1.
        1  => esc_html__( 'Partner updated.', 'edukul' ),
        2  => esc_html__( 'Custom field updated.', 'edukul' ),
        3  => esc_html__( 'Custom field deleted.', 'edukul' ),
        4  => esc_html__( 'Partner updated.', 'edukul' ),
        5  => isset( $_GET['revision'] ) ? sprintf( esc_html__( 'Partner restored to revision from %s', 'edukul' ), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
        6  => esc_html__( 'Partner published.', 'edukul' ),
        7  => esc_html__( 'Partner saved.', 'edukul' ),
        8  => esc_html__( 'Partner submitted.', 'edukul' ),
        9  => sprintf(
            esc_html__( 'Partner scheduled for: <strong>%1$s</strong>.', 'edukul' ),
            date_i18n( esc_html__( 'M j, Y @ G:i', 'edukul' ), strtotime( $post->post_date ) )
        ),
        10 => esc_html__( 'Partner draft updated.', 'edukul' )
    );
    return $messages;
}

add_action( 'init', 'register_partner_taxonomy' );
/**
  * Register partner taxonomy
*/
function register_partner_taxonomy() {
    $cat_slug = 'partner_category';

    $labels = array(
        'name'                       => esc_html__( 'Partner Categories', 'edukul' ),
        'singular_name'              => esc_html__( 'Category', 'edukul' ),
        'search_items'               => esc_html__( 'Search Categories', 'edukul' ),
        'menu_name'                  => esc_html__( 'Categories', 'edukul' ),
        'all_items'                  => esc_html__( 'All Categories', 'edukul' ),
        'parent_item'                => esc_html__( 'Parent Category', 'edukul' ),
        'parent_item_colon'          => esc_html__( 'Parent Category:', 'edukul' ),
        'new_item_name'              => esc_html__( 'New Category Name', 'edukul' ),
        'add_new_item'               => esc_html__( 'Add New Category', 'edukul' ),
        'edit_item'                  => esc_html__( 'Edit Category', 'edukul' ),
        'update_item'                => esc_html__( 'Update Category', 'edukul' ),
        'add_or_remove_items'        => esc_html__( 'Add or remove categories', 'edukul' ),
        'choose_from_most_used'      => esc_html__( 'Choose from the most used categories', 'edukul' ),
        'not_found'                  => esc_html__( 'No Category found.', 'edukul' ),
        'menu_name'                  => esc_html__( 'Categories', 'edukul' ),
    );
    $args = array(
        'labels'        => $labels,
        'rewrite'             => array('slug'=>$cat_slug),
        'hierarchical'  => true,
    );
    register_taxonomy( 'partner_category', 'partner', $args );
}