<?php
/* ---------------------------------------------------------------------------
 * Load default theme options
 * - To return default options to store in database.
 * --------------------------------------------------------------------------- */
if (!function_exists('kidsworld_default_option')) {
 function kidsworld_default_option() {
	 
	$general = array(
		'show-pagecomments' => 'false',
		'enable-responsive' => 'true',
		'show-mobileslider' => 'true'
	);

	$layout = array(
		'logo' => 'true',
		'show-breadcrumb' => 'true',
		'sub-title-bg' => KIDSWORLD_THEME_URI.'/images/breadcrumb.jpg',
		'sub-title-bg-repeat' => 'repeat',
		'sub-title-bg-position' => 'top left',
		'sub-title-parallax' => 'true',
		'breadcrumb-delimiter' => 'fa default',
		'show-boxed-layout-pattern-color' => 'true',
		'show-boxed-layout-bg-color' => 'true',
		'site-layout' => 'wide',
		'header-type' => 'fullwidth-header',
		'layout-stickynav' => 'true',
		'header-position' => 'above slider',
		'top-content' => '[vc_column el_class="vc-no-left-padding" width="1/2"][dt_sc_sociable class="" /][/vc_column][vc_column width="1/2" el_class="alignright vc-no-right-padding"][dt_sc_email text="admin@kidsworld.com" class="icomoon icon-Envelope" /][dt_sc_phone_no text="224 3361 3334" class="icomoon icon-Phone-2" /][/vc_column]',
		'menu-searchicon' => 'true',
		'menu-top-left-content' => '[dt_sc_phone_no text="+ 3326 225 RAYNOR" class="icon icon-phone2" /]',
		'menu-top-right-content' => '[dt_sc_email text="support@raynor.com" class="icon icon-mail" /]',
		'menu-hover-style' => 'dtfadeInUp',
		'menu-border' => 'true',
		'menu-border-radius-top' => '10',
		'menu-border-radius-right' => '10',
		'menu-border-radius-bottom' => '10',
		'menu-border-radius-left' => '10',
		'menu-boxshadow' => 'true',
		'footer-bg-repeat' => 'repeat-x',
		'footer-bg-position' => 'top left',
		'show-sociables' => 'on',
		'enable-footer' => 'true',
		'footer-columns' => '4'
	);	

	$widgetarea = array(
		'wtitle-style' => 'default'
	);
	
	$social = array(
		'social-1' => array(
			'icon' => 'fa-facebook',
			'link' => '#'
		),
		'social-2' => array(
			'icon' => 'fa-twitter',
			'link' => '#'
		),
		'social-3' => array(
			'icon' => 'fa-google-plus',
			'link' => '#'
		)
	);

	$pageoptions = array(
		'single-post-authorbox' => 'true',
		'single-post-related' => 'true',
		'post-archives-post-layout' => 'one-third-column',
		'post-format-meta' => 'true',
		'post-author-meta' => 'true',
		'post-date-meta' => 'true',
		'post-comment-meta' => 'true',
		'post-category-meta' => 'true',
		'post-tag-meta' => 'true',
		'enable-404message' => 'true',
		'show-notfound-bg-color' => 'true',
		'show-launchdate' => 'true',
		'show-comingsoon-bg-color' => 'true',
		'single-post-comments' => 'true',
		'post-style' => 'default',
		'post-archives-enable-excerpt' => 'true',
		'post-archives-excerpt' => '50',
		'post-archives-enable-readmore' => 'true',
		'post-archives-readmore' => '[dt_sc_button title="Read More" style="filled"]',
		'comingsoon-style' => 'type3'
	);

	$woo = array(
		'product-layout' => 'with-left-sidebar',
		'show-shop-standard-left-sidebar-for-product-layout' => 'true'
	);

	$colors = array(
		'theme-skin' => 'custom',
		'custom-default' => '#624dd6',
		'custom-light' => '#8152d4',
		'custom-dark' => '#532b99',

		'content-text-color' => '#374042',
		'content-link-color' => '#624dd6',
		'content-link-hcolor' => '#262c38',
	);

	$fonts = array(
		'content-font' => 'Roboto',
		'menu-font' => 'Roboto',
		'pagetitle-font' => 'Roboto',
		'h1-font' => 'Roboto',
		'h2-font' => 'Roboto',
		'h3-font' => 'Roboto',
		'h4-font' => 'Roboto',
		'h5-font' => 'Roboto',
		'h6-font' => 'Roboto',
		'font-style' => array( '100', '100italic', '200', '200italic','300', '300italic','400', '400italic','500', '500italic','600', '600italic','700', '700italic','800', '800italic','900', '900italic'),
		'content-font-size' => '15',
		'menu-font-size' => '15',
		'h1-font-size' => '32',
		'h2-font-size' => '30',
		'h3-font-size' => '24',
		'h4-font-size' => '20',
		'h5-font-size' => '18',
		'h6-font-size' => '16',
		'menu-weight' => '700',
		'menu-letter-spacing' => '0px',
		'h1-letter-spacing' => '0px',
		'h2-letter-spacing' => '0px',
		'h3-letter-spacing' => '0px',
		'h4-letter-spacing' => '0px',
		'h5-letter-spacing' => '0px',
		'h6-letter-spacing' => '0px',
		'body-line-height' => '28'
	);
	
	$data = array(
		'general' => $general,
		'layout'  => $layout,
		'widgetarea'  => $widgetarea,
		'social'  => $social,
		'pageoptions' => $pageoptions,
		'woo'	  => $woo,
		'colors'  => $colors,
		'fonts'   => $fonts
	);
	return $data;
	
 }
}

/* ---------------------------------------------------------------------------
 * Load default theme options
 * - To return default options to store in database.
 * --------------------------------------------------------------------------- */
if (!function_exists('kidsworld_show_footer_widgetarea')) {
function kidsworld_show_footer_widgetarea( $count ) {
	$classes = array (
		"1" => "dt-sc-full-width",
		"dt-sc-one-half",
		"dt-sc-one-third",
		"dt-sc-one-fourth",
		"dt-sc-one-fifth",
		"dt-sc-one-sixth",
		"1-2" => "dt-sc-one-half",
		"1-3" => "dt-sc-one-third",
		"1-4" => "dt-sc-one-fourth",
		"3-4" => "dt-sc-three-fourth",
		"2-3" => "dt-sc-two-third" );

	if ($count <= 6) :
		for($i = 1; $i <= $count; $i ++) :

			$class = $classes [$count];
			$class = esc_attr( $class );

			$first = ($i == 1) ? "first" : "";
			$first = esc_attr( $first );

			echo "<div class='column {$class} {$first}'>";
				if (function_exists ( 'dynamic_sidebar' ) && dynamic_sidebar ( "footer-sidebar-{$i}" )) : endif;
			echo "</div>";
		endfor;
	elseif ($count == 12 || $count == 13) :

		$a = array (
			"1-4",
			"1-4",
			"1-2" );

		$a = ($count == 12) ? $a : array_reverse ( $a );
		foreach ( $a as $k => $v ) :
			$class = $classes [$v];
			$class = esc_attr( $class );

			$first = ($k == 0 ) ? "first" : "";
			$first = esc_attr( $first );

			echo "<div class='column {$class} {$first}'>";
				if (function_exists ( 'dynamic_sidebar' ) && dynamic_sidebar ( "footer-sidebar-{$k}-{$v}" )) : endif;
			echo "</div>";
		endforeach;
	elseif ($count == 7 || $count == 8) :
		$a = array (
			"1-4",
			"3-4");

		$a = ($count == 7) ? $a : array_reverse ( $a );
		foreach ( $a as $k => $v ) :
			$class = $classes [$v];
			$class = esc_attr( $class );

			$first = ($k == 0 ) ? "first" : "";
			$first = esc_attr( $first );


			echo "<div class='column {$class} {$first}'>";
				if (function_exists ( 'dynamic_sidebar' ) && dynamic_sidebar ( "footer-sidebar-{$k}-{$v}" )) :endif;
			echo "</div>";
		endforeach;
	elseif ($count == 9 || $count == 10) :
		$a = array ( 
			"1-3",
			"2-3" );
		$a = ($count == 9) ? $a : array_reverse ( $a );

		foreach ( $a as $k => $v ) :
			$class = $classes [$v];
			$class = esc_attr( $class );

			$first = ($k == 0 ) ? "first" : "";
			$first = esc_attr( $first );

			echo "<div class='column {$class} {$first}'>";
				if (function_exists ( 'dynamic_sidebar' ) && dynamic_sidebar ( "footer-sidebar-{$k}-{$v}" )) :endif;
			echo "</div>";
		endforeach;
	elseif ($count == 11 ) :
		$a = array ( "1-4", "1-2", "1-4" );
		foreach ( $a as $k => $v ) :
			$class = $classes [$v];
			$class = esc_attr( $class );
			$first = ($k == 0 ) ? "first" : "";
			$first = esc_attr( $first );
			echo "<div class='column {$class} {$first}'>";
				if (function_exists ( 'dynamic_sidebar' ) && dynamic_sidebar ( "footer-sidebar-{$k}-{$v}" )) : endif;
			echo "</div>";
		endforeach;
	endif;
}
}


if(!function_exists('kidsworld_get_page_permalink_by_its_template')) {
	function kidsworld_get_page_permalink_by_its_template( $temlplate ) {
		$permalink = null;

		$pages = get_posts( array(
				'post_type' => 'page',
				'meta_key' => '_wp_page_template',
				'meta_value' => $temlplate,
				'suppress_filters' => 0  ) );

		if ( is_array( $pages ) && count( $pages ) > 0 ) {
			$login_page = $pages[0];
			$permalink = get_permalink( $login_page->ID );
		}
		return $permalink;
	}
}

/* ---------------------------------------------------------------------------
	* Whitelist Associate
	* --------------------------------------------------------------------------- */
	if ( ! function_exists( 'dt_theme_array_whitelist_assoc' ) ) {
		function dt_theme_array_whitelist_assoc( Array $array1, Array $array2 ) {
			if ( func_num_args() > 2 ) {
				$args = func_get_args();
				array_shift( $args );
				$array2 = call_user_func_array( 'array_merge', $args );
			}

			return array_intersect_key( $array1, array_flip( $array2 ) );
		}
	}

	/* ---------------------------------------------------------------------------
	* Post Type Support
	* --------------------------------------------------------------------------- */
	if ( ! function_exists( 'dt_theme_limit_post_types_support' ) ) {
	add_filter( 'fw_ext_page_builder_supported_post_types', 'dt_theme_limit_post_types_support', 1 );
	function dt_theme_limit_post_types_support( $all_post_types ) {
		$white_listed_post_types = array( '' ); //allowed custom post type names
		$post_types              = dt_theme_array_whitelist_assoc( $all_post_types, $white_listed_post_types );
		return $post_types;
	}
	}
?>